<?php
class Ultimate_Ai_Styling_Controller
{
  private $theme_setting_manager;

  public function __construct()
  {
    $this->theme_setting_manager = new Ultimate_AI_Theme_Setting_Manager();
    add_action('wp_head', [$this, 'ultimate_ai_load_custom_style'], 99999999);
  }

  public function ultimate_ai_load_custom_style()
  {
    $appearence_settings = $this->theme_setting_manager->ultimate_ai_get_theme_settings(["uai_theme_appearance_settings"])["uai_theme_appearance_settings"];
    //wp_enqueue_style("ultimate_ai_backend_style", UAI_ASSETS_URL_CSS . 'style.css');
    $colors_prop = [];
    $props_name = [
      ["name" => "--color-brand", "key" => "brand_color"],

      //buttons
      ["name" => "--color-button-primary", "key" => "button_primary_color_bg"],
      ["name" => "--color-button-primary-hover", "key" => "button_primary_color_hover"],
      ["name" => "--color-button-primary-text", "key" => "button_primary_color_text"],
      ["name" => "--color-button-secondary", "key" => "button_secondary_color_bg"],
      ["name" => "--color-button-secondary-hover", "key" => "button_secondary_color_hover"],
      ["name" => "--color-button-secondary-text", "key" => "button_secondary_color_text"],
    ];

    foreach ($props_name as $name) {
      if (!empty($appearence_settings[$name["key"]])) {
        $colors_prop[] = ["name" => $name["name"], "val" => $appearence_settings[$name["key"]]];
      }
    }

?>
    <style>
      #ultimate-ai-root,
      .ultimate_ai_modal {
        <?php foreach ($colors_prop as $prop) : ?><?= $prop["name"] . ":" . $prop["val"] . ";" ?><?php endforeach; ?>
      }

      #ultimate-ai-root .logo_and_dots_menu_bar_con.big_menu img {
        width: <?php echo $appearence_settings["logo_width"] ?? ""; ?>% !important;
      }

      #ultimate-ai-root .logo_and_dots_menu_bar_con.small_menu img {
        width: <?php echo $appearence_settings["small_logo_width"] ?? ""; ?>% !important;
      }
    </style>

<?php
  }
}

new Ultimate_Ai_Styling_Controller();
